<?php
/**
 * Template for categoria News
 * 
 * @package Microtest
 */

get_header();
$category = get_category( get_query_var( 'cat' ) );
      $cat_id = $category->cat_ID;
?>

<main class="news-main">
  <div class="thumbnail-hero" style="background-image:url('<?=(get_field('thumbnail', $category)); ?>')">
    <div class="container">
      <h1> <?= $category->name; ?></h1>
    </div>
  </div>
  <div class="newsGrid">
    <div class="container contieniNews">
      <?php
        $args = array(
            'posts_per_page'  => -1,
            'post_type'       => 'post',
            'post_status'     => 'publish',
            'category_name' => 'News',
            'posts_per_page' => 16,
            'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1),
        );
        $the_query = new WP_Query( $args );
      ?>
                  <?php 
            
            add_action( 'get_the_date', 'my_project_filter_publish_dates', 10, 3 );
 
            function my_project_filter_publish_dates( $the_date ) {            
                return date( 'd M:', strtotime( $the_date ) );
            }
            
            ?>
      <?php
        while( $the_query->have_posts()): $the_query->the_post();      
      ?>
      <a href="<?= get_permalink() ?>" class="singleNews">
        <div class="contentSingleNews">
          <div class="immagineThumbnail" style="background-image: url('<?php echo get_the_post_thumbnail_url() ?>')">
            <?php /* echo $post->post_content;  */?>     
          </div>
          <div class="titolo">

            <span class="data"><?= get_the_date() ?></span>
            <?= $post->post_title; ?>
          </div>
          <div class="readMore">
            <p>
              <?php _e('Read more', 'microtest'); ?>
            </p>
          </div>
          
        </div>
      </a>
      <?php
        endwhile; 
      ?>
      <div class="searchPagination">
          <?php bootscore_pagination($the_query->max_num_pages);  ?>
        </div>
    </div>
  </div>
</main>

<?php get_footer();