<?php
/*
*Template Name: Home Page
*@link https://codex.wordpress.org/Template_Hierarchy
*@package Microtest
*/

get_header(); 
?>

<main id="home-page">

    <section id="banner-1">

    <div class="section-1 bloccoSliderProdotti sezione <?php echo ICL_LANGUAGE_CODE; ?>">
        <div class="testi-sezione">
          <div class="testo-home-h2"><?php echo get_field("sezione_1_titolo"); ?></div>
        </div>
        <div id="slideProdottiHome" class="slideProdottiHome owl-carousel">
          <?php $sliderProdotti = get_field("slider_dei_prodotti");  ?>
          <?php 
            foreach ($sliderProdotti as $singleProduct) { ?>
            <a class="singleProductSlide prodotto-<?= $singleProduct->post_name ?>" href="<?= get_post_permalink($singleProduct->ID)?>">
              <div class="nomeProdotto">
                <?= get_the_title($singleProduct->ID); ?>
              </div>
              <div class="immagineProdottoSlide">
                <img src="<?= get_the_post_thumbnail_url($singleProduct->ID) ?>" alt="">
                <div class="nuvolaVerde">
                  <?= get_field("testo_in_slider", $singleProduct->ID); ?>
                </div>
              </div>
            </a>
          <?php }
          ?>
        </div>
      </div>


      <div class="section-2 bloccoTestHouse sezione">
        <div class="immagine_sezione_div">
          <img class="immagine_sezione" src="<?= get_field("sezione_2_immagine"); ?>">
        </div>
        <div class="testi-sezione">
          <div class="testo-home-h2"><?php echo get_field("sezione_2_titolo"); ?></div>
            <a href="<?php echo get_field("sezione_2_link"); ?><?php echo get_field('sezione_2_link_anchor'); ?>" class="moreButtonHome" target="_self" style="margin-left: 40px;">
              <?php _e("MORE", "microtest"); ?>
            </a>
        </div>
      </div>

      <div class="section-3 bloccoGeneralPurpose sezione">
        <div class="immagine_sezione_div">
          <img class="immagine_sezione" src="<?= get_field("sezione_3_immagine"); ?>">
        </div>
        <div class="testi-sezione">
          <div class="testo-home-h2">
            <?php echo get_field("sezione_3_titolo"); ?>
          </div>
            <a href="<?php echo get_field("sezione_3_link"); ?><?php echo get_field('sezione_3_link_anchor'); ?>" class="moreButtonHome" target="_self" style="margin-left: 40px;">
              <?php _e("MORE", "microtest"); ?>
            </a>
          </div>
        </div>
      
      
    </section>

  <section id="banner-2">
    <div class="sezione-slider-centrale">
      <?= do_shortcode(get_field("sezione_slider_centrale")); ?>
    </div>
  </section>

  <section id="banner-3">
    <div class="container-fluid">
      <div class="row">
        
        <div class="col-12 col-md-6 section-4 sezione" style="background-image:linear-gradient(0deg, rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.4)), url(<?= get_field("sezione_4_immagine")["url"]; ?>);">
          <div class="testi">
            <div class="titoloSezione"><?php echo get_field("sezione_4_titolo"); ?></div>
            <div class="home-btn">
              <a href="<?php echo get_field("sezione_4_link"); ?><?php echo get_field('sezione_4_link_anchor'); ?>" class="moreButtonHome"target="_self">
                  <?php _e("MORE", "microtest"); ?>
                </a>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-6 section-5 sezione" style="background-image:linear-gradient(0deg, rgba(0, 0, 0, 0.4), rgba(0, 0, 0, 0.4)), url(<?= get_field("sezione_5_immagine")["url"]; ?>);">
          <div class="testi">
            <div class="titoloSezione"><?php echo get_field("sezione_5_titolo"); ?></div>
            <div class="home-btn">
              <a href="<?php echo get_field("sezione_5_link"); ?><?php echo get_field('sezione_5_link_anchor'); ?>" class="moreButtonHome"target="_self">
                  <?php _e("MORE", "microtest"); ?>
                </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="banner-4">
    <div class="testi-sezione-6">
      <div class="testo-home-h2"><?php echo get_field("sezione_6_titolo"); ?></div>
      <div class="immagini"><?php echo get_field('sezione_6'); ?></div>
      <div class="home-btn">
        <a href="<?php echo get_field('sezione_6_link'); ?><?php echo get_field('sezione_6_link_anchor'); ?>" class="moreButtonHome" target="_self">
              <?php _e("MORE", "microtest"); ?>
            </a>
      </div>
    </div>
  </section>


  <style>

    @media (min-width: 576px){
    #modalEvento .modal-dialog {
          max-width: 600px;
      }
    }
  </style>
  <div class="modal fade" id="modalEvento" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
          <div class="modal-content" style="padding: 0px; padding-bottom: 0px; border: 0; position: relative">
              <!-- <div class="modal-header" style="margin-top: -15px; padding: 0">
                  <h5 class="modal-title" style="height: 15px">&nbsp;</h5>
                  
              </div> -->
              <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close" style="    opacity: 1;
    /* margin-right: -36px;
    margin-top: -7px; */
    background-color: white;
    border-radius: 20px;
    width: 32px;
    height: 32px;
    max-width: 32px;
    max-height: 32px;
    color: black;
    display: flex;
    align-items: center;
    justify-content: center;
    position: absolute;
    top: 10px;
    right: 10px;
    -webkit-appearance: none;
    color: rgb(0, 151, 57);
    border: unset;
    font-weight: 900;
    font-size: 25px;
    transform: unset;"><span aria-hidden="true" style="margin-bottom: 2px">×</span></button>
              <img class="bannerEvento" src="<?php echo get_stylesheet_directory_uri() . '/img/pop-up/pop-up_Semicon2023.jpg' ?>" alt="Semicon 2023">
            </div>
        </div>
    </div>
  
<?php 
	/* il banner deve comparire fra l'15 settembre 2022 e il 20 ottobre 2022 */
	/* mi salvo la data odierna, di inizio, e di fine evento */
	$adesso = new DateTime('now');
	/* $inizio= DateTime::createFromFormat('j-M-Y', '15-Sep-2022');
	$fine=DateTime::createFromFormat('j-M-Y', '21-Oct-2022'); */

  $inizio= DateTime::createFromFormat('j-M-Y', '26-Oct-2023');
	$fine=DateTime::createFromFormat('j-M-Y', '18-Nov-2023');
	/* semplifico la data perché contenga solo anno mese giorno */
	$adesso=$adesso->format('Y-m-d');
	$inizio=$inizio->format('Y-m-d');
	$fine=$fine->format('Y-m-d');
	/* trasformo la data in secondi */
	$adesso = strtotime($adesso);
	$inizio = strtotime($inizio);
	$fine = strtotime($fine);
	/* var_dump( $adesso) ;
	var_dump( $inizio) ;
	var_dump( $fine) ; */
	/* var_dump( $ora->diff($inizio)->days) ;
	var_dump( $ora->diff($fine)->days) ; */
	/* confronto le date */
	if ( ($adesso >= $inizio) && ( $adesso < $fine) /*  || is_user_logged_in() */ ) {
		?>
			<script type="text/javascript">
					jQuery(document).ready(function($){
						/* $(window).on('load', function() {
							$('#modalEvento').modal('show');
						}); */
            /* console.log("tempo attivo"); */
            var navigazioneInterna = "<?php echo $_GET['ref'] ?>";
              if (!(navigazioneInterna)) {
                $("#modalEvento").modal('show');
              }
					});
			</script>
		<?php
	} else {
		?>
		<script type="text/javascript">
			jQuery(document).ready(function($){
				console.log("tempo scaduto");
			});
		</script>
		<?php
	}
	/* if (){ */
		?>
</main>

<?php get_footer();