<?php
  /*
	 * Template Post Type: products
	 */

get_header();
?>

<div id="content" class="site-content paginaDelProdotto">
  <main id="main" class="single-product-container container">
    <div class="row">
      <div class="col-md-12">
          <h3 class="product_title gray"><?php the_title(); ?></h3>
      </div>
      <div class="col-12 col-md-6">
        <div class="immagineProdotto">
          <img src="<?= get_the_post_thumbnail_url(); ?>">
          <?php if (get_field('anchor_su_immagine_prodotto')) { ?>
            <div class="eventualiAnchor">
              <?php 
                for ($i=1; $i < 8; $i++) { 
                  if (get_field('anchor_'.$i)) {
                    $anchor = get_field("anchor_".$i);
              ?>
                <a href="#anchor<?= $anchor['numero_sezione_da_ancorare']?>" class="singleAnchor <?php if ($i === 1) echo "hoverJs"?> " style="top:<?= $anchor['anchor_coordinata_top'] ?>%; left: <?= $anchor['anchor_coordinata_left']?>%;">
                  <img src="<?= $anchor['anchor_img'] ?>" class="imgAnchor" alt="">

                  <!-- tooltip -->
                  <div class="tooltipAnchor" style="">
                    <div class="tooltipster-content">
                      <?= $anchor['titolo_anchor']?>
                    </div>
                    <div class="triangolinoNuvoletta" style="">
                      <span></span>
                    </div>
                  </div>
                </a>
              <?php
                  }
                }
              ?>
            </div>
            <?php 
            }
          ?>
        </div>
      </div>      
      <div class="col-12 col-md-6">
        <div class="short-description">
          <?php echo get_field('short_description'); ?>
        </div>
        <div class="description">
          <?php echo get_field('description'); ?>
        </div>
        <div id="info-tabs">
          <ul class="nav nav-tabs" id="pit" role="tablist">
            <li class="nav-item" role="presentation">
              <button 
                class="nav-link active" 
                id="more-tab" 
                data-bs-toggle="tab" 
                data-bs-target="#more" 
                role="tab" 
                aria-controls="more" 
                aria-selected="true">
                  <?php echo __('MORE INFO', 'microtest')?>
              </button>
            </li>

            <li class="nav-item" role="presentation">
              <button 
                class="nav-link" 
                id="data-tab" 
                data-bs-toggle="tab" 
                data-bs-target="#data" 
                role="tab" 
                aria-controls="data" 
                aria-selected="false">
                  <?php echo __('DATA SHEET', 'microtest')?>
              </button>
            </li>

            <?php if (get_field('ar_app')) : ?>
              <li class="nav-item" role="presentation">
                <button 
                  class="nav-link" 
                  id="app-tab" 
                  data-bs-toggle="tab" 
                  data-bs-target="#app" 
                  role="tab" 
                  aria-controls="app" 
                  aria-selected="false">
                    <?php echo __('3D APP', 'microtest')?>
                </button>
              </li>
            <?php endif ?>
          </ul>
        <?php 
              $linguaAttuale = ICL_LANGUAGE_CODE; 
              switch ($linguaAttuale) {
                  case "en": 
                      $numeroIubendaPrivacy = 85485223;
                      break;
                  case "it":
                      /* $iubenda_id = 16298921; */
                      $numeroIubendaPrivacy = 73833062;
                      break;
                  default:
                      $numeroIubendaPrivacy = 85485223;
              }
          ?>
          <div class="tab-content" id="pit-content">
            <div class="tab-pane fade show active MoreInfo" id="more" role="tabpanel" aria-labelledby="more-tab">
              <input type="hidden" id="name_product" value="<?php the_title(); ?>">
              <?= do_shortcode('[contact-form-7 id="774" title="MORE INFO EN"]') ?>
            </div>

            <div class="tab-pane fade DataSheet" id="data" role="tabpanel" aria-labelledby="data-tab">
              <input type="hidden" id="acf_datasheet" name="acf_datasheet" value="<?= get_field("datasheet_filename"); ?>">
              <?= do_shortcode('[contact-form-7 id="2467" title="DATASHEET EN"]') ?>
            </div>
            
            <?php if (get_field('ar_app')) : ?>
              <div class="tab-pane fade" id="app" role="tabpanel" aria-labelledby="app-tab">
                <div id="downloadApp">
                  <h5 style="text-align: center;"><?php _e("Download app now!", "microtest"); ?></h5>
                  <div class="row" style="display: table; margin-left: auto; margin-right: auto;" >
                    <a href="https://play.google.com/store/apps/details?id=net.microtest.armicrotest_android&pcampaignid=pcampaignidMKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1">
                      <img style="width:250px;" alt="Get it on Google Play" src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"/>
                    </a>
                    <a href="https://apps.apple.com/it/app/ar-microtest/id1593622673">
                      <img src="<?= get_stylesheet_directory_uri() ?>/img/Download_on_the_App_Store_Badge_US-UK_RGB_blk_092917.svg" style="padding: 26px; width: 250px;"/>
                    </a>
                  </div>
                </div>
              </div>
            <?php endif ?>

          </div>
        </div>

        <div id="applications" class="row">
          <h4 class="apps-title"><?php _e('Applications', 'microtest'); ?></h4>
            <div class="applicationsContainer">
              <?php $apps = get_field('applications'); 
                foreach($apps as $app) : 
                  $id_app = $app->ID;
                  $icona_verde = get_field('icona_verde', $id_app); ?>
                  <a href="<?= get_permalink($id_app) ?>">
                  <div class="app-img">
                    <img src="<?= $icona_verde ?>">
                    <figcaption class="figure-caption app-text"><?= get_the_title($id_app) ?></figcaption>
                  </div>
                </a>
              <?php endforeach ?> 
            </div>
        </div>
      </div>

      <div class="col-12">
        <?php 
        if (get_field('anchor_su_immagine_prodotto')) : ?>
          <?php 
          for ($i=1; $i < 8; $i++) :
            $testoAncorato = get_field("testi_estesi_ancorati");
            if ($testoAncorato['anchor_wysiwug_'.$i]) : ?>
            <div class="sezioneAncorata" id="anchor<?= $i ?>">
              <?= $testoAncorato['anchor_wysiwug_'.$i]?>
            </div>
          <?php
            endif;
          endfor;
          ?>
        <?php 
      endif; ?>
      </div>
    </div>
  </main>
</div>

<?php get_footer(); ?>
<script type="text/javascript">
  jQuery(document).ready(function($) {    
    $('#datasheet_file').val($('#acf_datasheet').val());
    $('#product_name').val($('#name_product').val());
    $('#datasheet_product').val($('#name_product').val());
  });
</script>