<?php
/**
 * Template Name: Careers
 * @link https://codex.wordpress.org/Template_Hierarchy
 * @package Microtest
 */

$args = array(
    'posts_per_page'  => -1,
    'post_type'       => 'position',
    'post_status'     => 'publish'
);
$the_positions = new WP_Query( $args );

get_header();
?>

<main id="content" class="main-careers">
    <div class="careers-header">
        <div class="thumbnail-hero" style="background-image:url('<?= get_the_post_thumbnail_url() ?>')">
            <h1><?php the_title(); ?></h1>
        </div>
    </div>
    
    <div class="section-careers">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6">
                    <div class="accordion" id="accordion-positions">
                        <?php for($i=0;$i<count($the_positions->posts);$i++) :
                            $position = $the_positions->posts[$i]; 
                            $post = get_post($position->ID); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading-<?=$i?>">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?=$i?>" aria-expanded="false" aria-controls="collapse-<?=$i?>">
                                        <?= $post->post_title; ?>
                                    </button>
                                </h2>
                                <div id="collapse-<?=$i?>" class="accordion-collapse collapse" aria-labelledby="heading-<?=$i?>" data-bs-parent="#accordion-positions">
                                    <div class="accordion-body">
                                        <?= $post->post_content; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endfor ?>
                    </div>
                </div>
                <div class="col-12 col-md-6 sezione-form">
                    <?php echo do_shortcode('[contact-form-7 id="881" title="Careers"]'); ?>
                </div>
            </div>
        </div>
    </div>

<?php get_footer();