<?php
/**
 * Template Name:   Guests Tracking Reception
 * @package Microtest
 */

get_header();
/* per evitare la cache di w3cache https://wordpress.org/support/topic/disable-caching-for-a-specific-page/ */
define('DONOTCACHEPAGE', true);

$today = isset($_GET["d"]) ? $_GET["d"] : date('Y-m-d');
 
$home_url = home_url();

if($_SERVER['REMOTE_ADDR'] != '213.182.68.59' && $_SERVER['REMOTE_ADDR'] != '93.33.213.130') {
  wp_redirect(home_url());
} else {
  get_header(); 
}

global $wpdb;

$formatter = new IntlDateFormatter(
  'it_IT',
  IntlDateFormatter::FULL,
  IntlDateFormatter::NONE,
  'Europe/Rome',
  IntlDateFormatter::GREGORIAN,
  'd/MM/yyyy HH:mm'
);
?>
 
<style>
  #nav-main .loghetto-anniversario,
  #nav-main .offcanvas.offcanvas-end,
  #nav-main .header-actions{
      display: none!important;
      width: 0;
      height:0;
      overflow: hidden;
      opacity: 0;
      cursor-events: none;
  }
  #nav-main .container{
      justify-content: center;
  }
  /* #page{
      background-color: rgb(220, 240, 227);
  } */ 

  #content{
    min-height: unset;
  }
  #breadcrumbs{
      opacity: 0;
      cursor-events: none;
  }
  #main{
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      flex-direction: column;
  }
  #main .container{
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
  }
  #main h1{
      padding: 35px 0 30px;
      margin: 0;
  }

  #main iframe{
      width: 100%;
      max-width: 660px;
  }
  #main .intestazione{
      width: 95%;
      max-width: 590px;
      display: flex;
      align-items: center;
      justify-content: center;
      text-align: center;
      border-radius: 15px;
      min-height: 220px;
      margin-top: 25px;
  }
  #main .intestazione img{
      /* width: 60%;
      height: auto;
      max-width: 350px; */
      border-radius: 15px;
      border-bottom-left-radius: 0;
  }
  .bottoniNewsDownload{
      display: inline-block;
      background-color: White;
      color:  rgb(255, 255, 255);
      border-radius: 5px 5px 5px 0px;
      background-color: rgb(255, 255, 255);
      background-color:  var(--coloreprimario);
      width: 70px;
      text-align: center;
      font-size: 14px;
      font-weight: 700;
      padding: 10px;
      transition: all 0.3s;
      margin-top: 15px;
      width: auto;
  }
  .bottoniNewsDownload:hover{
      background-color: var(--coloreprimario);
      color: white;
  }

  .wpcf7 input[type="submit"]{
    margin-left: auto;
    margin-right: auto;
  }
  .single-visitatore span{
    display: flex;
    align-items: center;
    justify-content: flex-start;
    margin-top: 5px;
    margin-bottom: 5px;
  }
  
</style>

<main id="content" class="track-guests-reception">
  <div class="container">
    <?php
      $todayMostra = DateTime::createFromFormat('Y-m-d', $today);
      
      $results = $wpdb->get_results($wpdb->prepare("SELECT id, first_name, last_name, guest_email, company_name, created_at, left_building FROM `{$wpdb->prefix}checkguests` WHERE DATE(created_at) = %s AND left_building IS NULL ORDER BY `created_at` DESC", $today)); 

      if (isset($_GET['order']) && $_GET['order'] === 'nome') {
        $results = $wpdb->get_results($wpdb->prepare("SELECT id, first_name, last_name, guest_email, company_name, created_at, left_building FROM `{$wpdb->prefix}checkguests` WHERE DATE(created_at) = %s AND left_building IS NULL ORDER BY `first_name` ASC , `last_name` ASC", $today)); 
      }
    ?>

    <h1>Ospiti Giornalieri <br> <?php echo substr($formatter->format($todayMostra), 0, -5); ?> <br> <a class="bottoniNewsDownload ricarica-pagina" href="<?php echo $home_url; ?>/guests-registration/" target="_blank">Pagina Registrazione Visite</a>  <a class="bottoniNewsDownload ricarica-pagina" href="#" onclick="location.reload(); return false;">Ricarica Pagina</a> 
      
    <?php /* if($_SERVER['REMOTE_ADDR'] == '213.182.68.59') { */ ?>
      <br>
      <?php $oggi = new DateTime(); ?>
      <script>
        document.addEventListener('DOMContentLoaded', function() {
          var dateInput = document.getElementById('start');
          dateInput.addEventListener('change', function() {
            /* al cambio del datepicked, refresha la pagina inserendo il parametro della data come variabile get, se sono presenti altre variabili GET preservale nel nuovo url */
            var selectedDate = dateInput.value;
            /* se l'input viene cambiato svuotandolo, allora fai conto che si stato insesito il girno corrente */
            if (!selectedDate) {
              var today = new Date();
              var dd = String(today.getDate()).padStart(2, '0');
              var mm = String(today.getMonth() + 1).padStart(2, '0'); //January is 0!
              var yyyy = today.getFullYear();
              selectedDate = yyyy + '-' + mm + '-' + dd;
            }
            var urlParams = new URLSearchParams(window.location.search);
            urlParams.set('d', selectedDate);
            window.location.search = urlParams.toString();
          });
        });
      </script>
      <span style="font-size: 0.4em; color: black;">
        Vuoi visualizzare una data diversa?  Selezionala qui: 
        <input type="date" id="start" name="trip-start" value="<?= $today ?>" min="2024-10-03" max="<?= $oggi->format('Y-m-d') ?>" style="color: var(--coloreprimario)" />
      </span>
    <?php /* } */ ?>
    
    </h1>

     <style> 
      <?php
      if (isset($_GET['order']) && $_GET['order'] === 'nome') { ?>
        .gestisci-ordine .ordine-nome{
          color: #000!important; 
          text-decoration: underline!important;
        }
        <?php } else { ?>
        .gestisci-ordine .ordine-orario{
          color: #000!important;
          text-decoration: underline!important;
        }
        <?php }
      ?>
    </style>
    <div class="gestisci-ordine">
      <div class="ordine-visualizzazione">
        <a href="<?= get_the_permalink() ?>?d=<?= $today ?>&order=nome" class="ordine-nome">
          <?php if (isset($_GET['order']) && $_GET['order'] === 'nome') { ?> 
              Ordinati per nome
          <?php } else { ?>
              Ordina per nome
          <?php } ?>
        </a> 
        &nbsp; | &nbsp;
        <a href="<?php echo get_the_permalink() ?>?d=<?= $today ?>" class="ordine-orario"> 
          <?php if (isset($_GET['order']) && $_GET['order'] === 'nome') { ?>
            Ordina per orario d'entrata e uscita
          <?php } else { ?>
            Ordinati per orario d'entrata e uscita 
          <?php } ?>
        </a>
      </div>
    </div>

    <?php     
    if(count($results)) { ?>
      
      <h3>Visitatori Presenti: <?php echo count($results) ?></h3>
      <div class="visitatori-dentro contieni-visitatori" style="margin-bottom: 50px;">
        <div class="single-visitatore ancora-dentro row" style="font-weight: 600">
          <span class="nome">Nome</span>
          <span class="cognome">Cognome</span>
          <span class="email">Email</span> 
          <span class="azienda"> Azienda</span>
          <span class="orario">Ingresso</span>
          <span class="uscita">Uscita</span>
        </div>
        <?php for ($i=0; $i < count($results); $i++) {
            if(!($results[$i]->left_building)){ ?>
            <div class="single-visitatore ancora-dentro row" data-identificativo="<?php echo $results[$i]->id; ?>">
              <span class="nome"><?php echo $results[$i]->first_name; ?></span>
              <span class="cognome"><?php echo $results[$i]->last_name; ?></span>
              <span class="email"><?php echo $results[$i]->guest_email; ?></span>
              <span class="azienda"> <?php echo $results[$i]->company_name; ?></span>
                <?php  
                $date = new DateTime($results[$i]->created_at, new DateTimeZone('Europe/Rome')); 
                ?>
                <span class="orario"><?php echo $formatter->format($date); ?></span>
              <span class="uscita">
                <button type="button" class="bottone-uscita" data-bs-toggle="modal" data-bs-target=".modal-conferma" data-id="<?php echo $results[$i]->id; ?>" data-name="<?php echo $results[$i]->first_name . ' ' . $results[$i]->last_name; ?>">
                Registra Uscita
                </button>
              </span>
            </div>
          <?php } 
          }
        ?>
      </div>
    <?php } ?>
    
    <?php
      $resultsUsciti = $wpdb->get_results($wpdb->prepare("SELECT id, first_name, last_name, guest_email, company_name, created_at, left_building FROM `{$wpdb->prefix}checkguests` WHERE DATE(created_at) = %s AND left_building IS NOT NULL ORDER BY `left_building` DESC", $today)); 

      if (isset($_GET['order']) && $_GET['order'] === 'nome') {
        $resultsUsciti = $wpdb->get_results($wpdb->prepare("SELECT id, first_name, last_name, guest_email, company_name, created_at, left_building FROM `{$wpdb->prefix}checkguests` WHERE DATE(created_at) = %s AND left_building IS NOT NULL ORDER BY `first_name` ASC , `last_name` ASC", $today)); 
      }

    ?>
    <?php if(count($resultsUsciti)) {  ?>
      <h3>Visitatori Usciti: <?php echo count($resultsUsciti) ?></h3>
      <div class="visitatori-usciti contieni-visitatori">
        <div class="single-visitatore gia-uscito row"  style="font-weight: 600">
          <span class="nome">Nome</span>
          <span class="cognome">Cognome</span>
          <span class="email">Email</span>
          <span class="azienda">Azienda</span>
          <span class="orario">Ingresso</span>
          <span class="uscita">Uscita</span>
        </div>
        <?php 
        for ($i=0; $i < count($resultsUsciti); $i++) {
            if($resultsUsciti[$i]->left_building){ ?>
            <div class="single-visitatore gia-uscito row" data-identificativo="<?php echo $resultsUsciti[$i]->id; ?>">
              <span class="nome"><?php echo $resultsUsciti[$i]->first_name; ?></span>
              <span class="cognome"><?php echo $resultsUsciti[$i]->last_name; ?></span>
              <span class="email"><?php echo $resultsUsciti[$i]->guest_email; ?></span>
              <span class="azienda"><?php echo $resultsUsciti[$i]->company_name; ?></span>
              <?php   $date = new DateTime(($resultsUsciti[$i]->created_at), new DateTimeZone('Europe/Rome'));  ?>
              <span class="orario"><?php echo $formatter->format($date); ?></span>
              <?php   $date = new DateTime(($resultsUsciti[$i]->left_building) , new DateTimeZone('Europe/Rome')); ?>
              <span class="uscita"><?php echo $formatter->format($date); ?></span>
            </div>
          <?php } 
          }
        ?>
      </div>
    <?php } ?>

    <?php 
    if (count($results) === 0 && count($resultsUsciti) === 0) { ?>
      <h3 style="margin-bottom: 100px; margin-top: 100px">
        Nessun visitatore il giorno <?php echo substr($formatter->format($todayMostra), 0, -5); ?> 
      </h3>
    <?php } ?>

  </div>


  <div class="modal fade modal-conferma">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header" style="background-color: rgba(0, 151, 57,15%); border-bottom: 0">
          <h5 class="modal-title">Conferma uscita visitatore</h5>
          <button type="button" class="close" data-bs-dismiss="modal" style="    opacity: 1;
      /* margin-right: -36px;
      margin-top: -7px; */
      background-color: transparent;
      border-radius: 20px;
      border: 0;
      width: 32px;
      height: 32px;
      max-width: 32px;
      max-height: 32px;
      color: black;
      display: flex;
      align-items: center;
      justify-content: center;
      position: absolute;
      top: 10px;
      right: 10px;
      -webkit-appearance: none;
      transform: unset; font-size: 2em">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <p>Confermi che il visitatore <b class="nome-utente-uscito"></b> è uscito dall'edificio? <br>L'azione è irreversibile</p>
        </div>
        <div class="modal-footer" style="border-top: 0">
          <button id="annulla-conferma" class="btn btn-danger" data-bs-dismiss="modal">Annulla</button>
          <button type="button" class="btn btn-success" id="conferma-btn">Conferma</button>
        </div>
      </div>
    </div>
  </div>


</main>

<script>
  jQuery(document).ready(function($) {

    $('.modal-conferma').on('show.bs.modal', function (event) {
      var button = $(event.relatedTarget); // Button that triggered the modal
      var userName = button.data('name'); // Extract info from data-* attributes
      var modal = $(this);
      modal.find('.nome-utente-uscito').text(userName);
    });

    /* registro uscita dell'ospite */
    let idCliccato = '';
    $('.ancora-dentro .bottone-uscita').on('click', function() {
      idCliccato = $(this).data('id');
    });

    $('#conferma-btn').on('click', function() {
      $.ajax({
          url: 'https://www.microtest.net/wp-admin/admin-ajax.php',
          type: 'POST',
          data: {
            action: 'checkguests_exit_save',
            'id': idCliccato,
          },
          success: function(response, status, xhr) {
            if (response.data === "true") {
              console.log('Utente Uscito');
              $('.modal-conferma').modal('hide');
              /* alert('Uscita registrata correttamente'); */
              location.reload();
            }
          },
          error: function(xhr, status, error) {
            /* $('#conferma-btn').attr('disabled', false);
            console.log('Errore nella richiesta: ' + error); */
           /*  alert('C\'è stato un errore: ', xhr, status, error); */
          }
        });
    });

  });
</script>

<?php 
  get_footer();
